// $Id: CDLLLoader.cpp,v 1.8 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CDLLLoader.hpp"
#include "../Host/CFileManager.hpp"
#include "../Exceptions/CException.hpp"

using Exponent::Host::CDLLLoader;
using Exponent::Host::CFileManager;
using Exponent::Exceptions::CException;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CDLLLoader, CCountedObject);

//	===========================================================================
CDLLLoader::CDLLLoader()
		  : m_dllHandle(NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CDLLLoader);
}

//	===========================================================================
CDLLLoader::CDLLLoader(const CString &dllName)
		  : m_dllHandle(NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CDLLLoader);
	this->loadDLL(dllName);
}

//	===========================================================================
CDLLLoader::~CDLLLoader()
{
	EXPONENT_CLASS_DESTRUCTION(CDLLLoader);
	this->unloadDLL();
}

//	===========================================================================
void CDLLLoader::loadDLL(const CString &dllName)
{
	if (!CFileManager::doesFileExist(dllName))
	{
		CString theMessage = dllName;
		theMessage.appendString(" doesnt exist");
		throw CException(theMessage, "CDLLLoader::loadDll(const CString &)");
	}
	m_dllName = dllName;

#ifdef WIN32
	m_dllHandle = LoadLibrary(m_dllName.getString());
#else
	CFStringRef thePath = m_dllName.getStringAsCFStringRef();
	CFURLRef theURL     = CFURLCreateWithFileSystemPath(kCFAllocatorDefault, thePath, kCFURLPOSIXPathStyle, TRUE);
	m_dllHandle			= CFBundleCreate(kCFAllocatorDefault, theURL);
	if (CFBundleIsExecutableLoaded(m_dllHandle))
	{
		CFRetain(m_dllHandle);
	}
	else
	{
		if (!CFBundleLoadExecutable(m_dllHandle))
		{
			CString theMessage = dllName;
			theMessage.appendString(" Failed to load");
			throw CException(theMessage, "CDLLLoader::loadDLL(const CString &)");
		}
	}
	CFRelease(thePath);
	CFRelease(theURL);
#endif
}

//	===========================================================================
void CDLLLoader::unloadDLL()
{
#ifdef WIN32
	BOOL b = FreeLibrary(m_dllHandle);
#else
	if (CFGetRetainCount(m_dllHandle) == 1)
	{
		CFBundleUnloadExecutable(m_dllHandle);
	}
	CFRelease(m_dllHandle);
#endif
}

//	===========================================================================
void *CDLLLoader::getFunction(const CString &functionName)
{
#ifdef WIN32
	return (void*)GetProcAddress(m_dllHandle, functionName.getString());
#else
	CString funcName     = functionName;
	CFStringRef function = funcName.getStringAsCFStringRef();
	void *theFunction = CFBundleGetFunctionPointerForName(m_dllHandle, function);
	CFRelease(function);
	return theFunction;
#endif
}